//	CFolderDos.h

#ifndef _H_CFolderDos
#define _H_CFolderDos

#include "CFolder.h"
#include "DosStructs.h"

typedef		OSErr	Dos_ForEachEntryCB(
	CFolderDos			*thiz, 
	Dos_DirEntry		*entry, 
	Dos_SectorSpec		sectorSpec, 
	Dos_EntryIndex		entryIndex, 
	Boolean				*done, 
	void				*data);

typedef		OSErr	Dos_ForEachDirSectorCB(
	CFolderDos			*thiz, 
	Dos_SectorSpec		sectorSpec, 
	Dos_DirSector		*dirSectorP,
	Boolean				*doneBP, 
	void				*data);

class CFolderDos : public CFolder {

	public:	
	
	OSErr	IFolderDos(
		CDiskDos			*cDiskDos, 
		Dos_SectorSpec		sector);

	virtual	void	Dispose(void);
	
	static	OSErr	Dos_CacheDirectory(
		CFolderDos			*thiz, 
		Dos_SectorSpec		sectorSpec, 
		Dos_DirSector		*dirSectorP, 
		Boolean				*doneBP, 
		void				*data);

	static	OSErr	Dos_DisposeDirectory(
		CFolderDos			*thiz, 
		Dos_SectorSpec		sectorSpec, 
		Dos_DirSector		*dirSectorP, 
		Boolean				*doneBP, 
		void				*data);

	OSErr			AddEntries(Boolean normalB, Boolean deletedB);

	OSErr			Dos_ForEachDirSector(
		Dos_ForEachDirSectorCB	Dos_ForEachUserCB, 
		void					*data);

	OSErr			Dos_DeleteEntry(Dos_EntryLocSpec entryLoc);
	Dos_DirEntry	*GetEntry(Dos_SectorSpec sector, Dos_EntryIndex entryIndex);
	Dos_SectorSpec	GetNextDirSector(Dos_SectorSpec sector);

	virtual	void		ConformStrLen(char* nameStr);
	virtual	Boolean		GetUniqueName(char *fileName);
	
	Boolean				GetEmptyEntry(Dos_EntryLocSpec *entryLoc);

	static	OSErr		Dos_ForEachDirSectorEntry(
		CFolderDos			*thiz, 
		Dos_SectorSpec		sectorSpec, 
		Dos_DirSector		*dirSectorP, 
		Boolean				*doneBP, 
		void				*data);

	OSErr			Dos_ForEachEntry(
		Dos_ForEachEntryCB	Dos_ForEachUserCB, 
		void				*data);


	static	OSErr	Dos_MakeNewEntryCB(
		CFolderDos			*thiz, 
		Dos_DirEntry		*entry, 
		Dos_SectorSpec		sectorSpec, 
		Dos_EntryIndex		entryIndex, 
		Boolean				*done, 
		void				*data);

	OSErr			Dos_MakeNewEntry(
		Dos_DirEntry		*entry, 
		Dos_SectorSpec		sectorSpec, 
		Dos_EntryIndex		entryIndex, 	//	within cur sector
		Dos_EntryIndex		directoryIndex, //	within entire catalog
		CEntry				**newEntry0);

	virtual	OSErr			NewFile(Boolean isFolder, CEntry **entryH);

	virtual	OSErr		Delete(Boolean warnB = FALSE, CDialogCopy *copyP0 = NULL);
	virtual	OSErr		UnDelete(Boolean recursiveB = FALSE, CDialogCopy *copyP0 = NULL);

	private:
	typedef CFolder _inherited;
};


#endif
